#ifndef CYPRESS_BOOTLOADER_H_
#define CYPRESS_BOOTLOADER_H_

/* Silicon Family ID's */
#define GEN_FOUR_ID                                 0x90
#define GEN_FOUR                                    4
#define GEN_SIX_ID_CYTAT81X                         0xA2
#define GEN_SIX_ID                                  0xA6
#define GEN_SIX                                     6

/* Controller ID's */
#define CY8CTMA460AS_33                             0x0188        /* CY8CTMA460AS-33 */
#define CYAT81688_100AA61                           0x1619        /* CYAT81688-100AA61 */

/* Bootloader packet values */
#define CYPRESS_BOOTLOADER_PACKET_START             0x01
#define CYPRESS_BOOTLOADER_PACKET_END               0x17

/* Packet offsets */
#define CYPRESS_BOOTLOADER_PACKET_START_OFFSET      0
#define CYPRESS_BOOTLOADER_PACKET_STATUS_OFFSET     1
#define CYPRESS_BOOTLOADER_PACKET_DATA_LENGTH_MSB   2
#define CYPRESS_BOOTLOADER_PACKET_DATA_LENGTH_LSB   3

/* Bootloader command packet offsets */
#define CYPRESS_BOOTLOADER_CMD_PACKET_SYNC_OFFSET    0
#define CYPRESS_BOOTLOADER_CMD_PACKET_START_OFFSET   1
#define CYPRESS_BOOTLOADER_CMD_PACKET_CMD_OFFSET     2
#define CYPRESS_BOOTLOADER_CMD_PACKET_DATA_LEN_LSB   3
#define CYPRESS_BOOTLOADER_CMD_PACKET_DATA_LEN_MSB   4
#define CYPRESS_BOOTLOADER_CMD_PACKET_DATA_OFFSET    5

/* Bootloader Commands */
#define CYPRESS_BOOTLOADER_CMD_HOST_SYNC            0xFF
#define CYPRESS_BOOTLOADER_CMD_PACKET_START         0x01
#define CYPRESS_BOOTLOADER_CMD_PACKET_END           0x17

#define CYPRESS_BOOTLOADER_CMD_ENTER_ACTIVE_STATE   0x38
#define CYPRESS_BOOTLOADER_CMD_CLEAR_ERRORS         0x40
#define CYPRESS_BOOTLOADER_CMD_CLEAR_ERRORS_REPLY_LEN 1
  /* len 8 */
#define CYPRESS_BOOTLOADER_CMD_INITIATE_BOOTLOAD    0x48
#define CYPRESS_BOOTLOADER_CMD_PROGRAM_ROW          0x39
#define CYPRESS_BOOTLOADER_CMD_VERIFY_ROW           0x3A
#define CYPRESS_BOOTLOADER_CMD_VERIFY_CRC           0x31
  /* len 8 */
#define CYPRESS_BOOTLOADER_CMD_SEND_DATA            0x37
#define CYPRESS_BOOTLOADER_CMD_EXIT_CRC             0x3B
  /* len 8 */
#define CYPRESS_BOOTLOADER_CMD_EXIT_NO_CRC          0x3C
  /* len 8 */

/* Bootloader Command Return Status */
#define SUCCESS                                     0x00
#define INCORRECT_COMMAND                           0x01
#define FLASH_VERIFICATION_FAILED                   0x02
#define DATA_SIZE_OUT_OF_RANGE                      0x03
#define DATA_IN_INCORRECT_FORM                      0x04
#define UNRECOGNIZED_COMMAND                        0x05
#define CRC_DOES_NOT_MATCH                          0x08
#define INVALID_FLASH_ROW                           0x0A
#define FLASH_ROW_WRITE_PROTECTED                   0x0B

/* Retrun Packet */
#define RETURN_PACKET_DATA_LENGTH_LSB               2
#define RETURN_PACKET_DATA_LENGTH_MSB               3
#define RETURN_PACKET_HEADER_LEN                    4
#define RETURN_PACKET_TAIL_LEN                      3

/* CYACD File Format */
    /* Header */
#define SILICON_ID                                  0
#define CHIP_REVISION                               8  /* Its 8 characters into the header line */
#define CHECKSUM_TYPE   5

    /* Row */
#define FILE_HEADER_SIZE    13
#define LINE_HEADER_SIZE    5
#define MAX_LINE_SIZE       4096

/* Firmware Update States */
#define OPEN_FILE           0
#define ACTIVE_STATE        1
#define INITIATE_BOOTLOAD   2
#define PROGRAM_RECORD      3
#define CHANGE_TO_CONFIG_TEST_MODE 4
#define CALIBRATE_IDACS     5
#define FINISHED            6

/* Program Record States */
#define WRITE               0
#define VERIFY              1
#define CHECK_RESULT        2

/* Bootloader States */
#define IDLE                0
#define ACTIVE              1
#define APPLICATION_RUNNING 2
#define WAITING_UPDATE      3
#define CLEARING_ERROR      4

/* Bootloader command operation */
#define READ                1

#define CYACD_DATA_OFFSET   11

/* Capacitive Sensing Modes */
#define SENSING_MODE_MUTUAL_CAP_FINE     0x00
#define SENSING_MODE_MUTUAL_CAP_BUTTON   0x01
#define SENSING_MODE_SELF_CAP            0x02

#define SENSING_MASK                     0x07

#define CTRL_SENSING_MODE_MUTUAL_CAP_FINE   0x01
#define CTRL_SENSING_MODE_MUTUAL_CAP_BUTTON 0x02
#define CTRL_SENSING_MODE_SELF_CAP          0x04

#define LSB                 0x00FF
#define MSB                 0xFF00

#define MAX_SLOG_BUFFER          255
#define MIN_RECORD_DATA_LENGTH   3

#define HEX(x)  x-'0'>9?x-'A'>5?(x-'a')+10:(x-'A')+10:x-'0'

struct cyacd_record {
    uint8_t array_id;
    uint16_t row_number;
    uint16_t record_length;
    uint8_t *data;
    uint8_t cksum;
    struct cyacd_record *next;
};

#endif /* CYPRESS_BOOTLOADER_H_ */

#if defined(__QNXNTO__) && defined(__USESRCVERSION)
#include <sys/srcversion.h>
__SRCVERSION("$URL: http://svn.ott.qnx.com/product/branches/7.0.0/trunk/hardware/mtouch/cypress/bootloader.h $ $Rev: 886397 $")
#endif
